<?php
require "connection.php";

$response = array();

// Validate and sanitize input data
$item_title = mysqli_real_escape_string($con, $_POST["item_title"]);
$item_price = floatval($_POST["item_price"]); // Assuming price is a float, you might need additional validation
$item_description = mysqli_real_escape_string($con, $_POST["item_description"]);
$category_name = mysqli_real_escape_string($con, $_POST["category_name"]);
$subcategory_name = mysqli_real_escape_string($con, $_POST["subcategory_name"]);
$location_name = mysqli_real_escape_string($con, $_POST["location_name"]);
$childcategory_name = mysqli_real_escape_string($con, $_POST["childcategory_name"]);
$condition_name = mysqli_real_escape_string($con, $_POST["condition_name"]);
$user_id = intval($_POST["user_id"]); // Assuming user_id is an integer, you might need additional validation

$images = $_FILES["images"];

$userCheckQuery = "SELECT * FROM user WHERE user_id = '$user_id'";
$userCheckResult = mysqli_query($con, $userCheckQuery);

if (mysqli_num_rows($userCheckResult) > 0) {
    // Check if any image is uploaded
    if (!empty($images['name'][0])) {
        $upload_directory = "uploads/";

        $image_paths = array();

        // Handle multiple file uploads
        if (!is_array($images['name'])) {
            // If only a single file is uploaded, convert it to an array for consistent processing
            $images = array(
                'name'     => array($images['name']),
                'type'     => array($images['type']),
                'tmp_name' => array($images['tmp_name']),
                'error'    => array($images['error']),
                'size'     => array($images['size'])
            );
        }

        foreach ($images['name'] as $key => $image_name) {
            $image_temp = $images['tmp_name'][$key];
            $image_path = $upload_directory . $image_name;

            // Add additional check to ensure uploaded file is an image
            $imageFileType = strtolower(pathinfo($image_path, PATHINFO_EXTENSION));
            if (in_array($imageFileType, array("jpg", "jpeg", "png", "gif"))) {
                if (move_uploaded_file($image_temp, $image_path)) {
                    $image_paths[] = $image_path;
                } else {
                    $response["error"] = "002";
                    $response["message"] = "Failed to upload one or more images.";
                    echo json_encode($response);
                    exit();
                }
            } else {
                $response["error"] = "003";
                $response["message"] = "Invalid image format. Please upload JPG, JPEG, PNG, or GIF.";
                echo json_encode($response);
                exit();
            }
        }

        // Check if any image paths were collected
        if (count($image_paths) > 0) {
            // Insert data into the sell table
            $image_paths_json = json_encode($image_paths);
            $insertQuery = "INSERT INTO sell_tbl (item_title, item_price, item_description, category_name, subcategory_name, location_name, childcategory_name, condition_name, user_id, images) 
                            VALUES ('$item_title', '$item_price', '$item_description', '$category_name', '$subcategory_name', '$location_name', '$childcategory_name', '$condition_name', '$user_id', '$image_paths_json')";

            $result = mysqli_query($con, $insertQuery);

            if ($result) {
                $response["error"] = "200";
                $response["message"] = "Product added successfully";
            } else {
                $response["error"] = "Error executing query: " . mysqli_error($con);
            }
        } else {
            $response["error"] = "003";
            $response["message"] = "No valid images provided.";
        }
    } else {
        $response["error"] = "003";
        $response["message"] = "Images not provided or invalid format.";
    }
} else {
    $response["error"] = "404";
    $response["message"] = "User does not exist";
}

echo json_encode($response);

mysqli_close($con);
?>
