<?php

// Include the database connection file
require_once 'connection.php';
require_once 'alert_Notification.php';

// Function to send a message
function sendMessage($con, $senderId, $receiverId, $messageText)
{
    // Prepare the insert query with the current timestamp for sent_at and seen_at
    $sql = "INSERT INTO messages (sender_id, receiver_id, message_text, sent_at, is_deleted) 
            VALUES ('$senderId', '$receiverId', '$messageText', NOW(), 0)";

    // Execute the query
    if (mysqli_query($con, $sql)) {
        // Fetch the device token of the receiver from the database
        $getTokenQuery = "SELECT user_token FROM user WHERE user_id = '$receiverId'";
        $tokenResult = mysqli_query($con, $getTokenQuery);

        if ($tokenResult) {
            $tokenRow = mysqli_fetch_assoc($tokenResult);
            $token = $tokenRow['user_token'];

            // Send push notification using the retrieved device token
            $title = "New Message";
            $message = "You have received a new message";
           sendAlertNotitfication($token, $title, $message);

            return "Message sent successfully.";
        } else {
            // Handle error if query fails
            return "Error fetching device token: " . mysqli_error($con);
        }
    } else {
        // Handle error if query to insert message fails
        return "Error sending message: " . mysqli_error($con);
    }


}




// Function to receive messages for a user
function receiveMessages($con, $receiverId)
{
    // Prepare the select query
    $sql = "SELECT * FROM messages WHERE receiver_id='$receiverId'";

    // Execute the query
    $result = mysqli_query($con, $sql);

    // Fetch all rows
    $messages = mysqli_fetch_all($result, MYSQLI_ASSOC);

    return $messages;
}

// Function to update seen_at field for a message
function updateSeenAt($con, $messageId)
{
    // Prepare the update query to set seen_at to current timestamp
    $sql = "UPDATE messages SET seen_at = NOW() WHERE message_id = '$messageId'";

    // Execute the query
    if (mysqli_query($con, $sql)) {
        return "Seen_at updated successfully for message with ID: $messageId.";
    } else {
        return "Error updating seen_at: " . mysqli_error($con);
    }
}

// Function to get messages between two users with pagination
function getMessagesBetweenUsers($con, $senderId, $receiverId, $initialRow, $finalRow)
{
    // Prepare the select query to fetch undeleted messages between users
    $sql = "SELECT * FROM messages 
            WHERE ((sender_id = '$senderId' AND receiver_id = '$receiverId') 
                OR (sender_id = '$receiverId' AND receiver_id = '$senderId'))
            AND is_deleted = 0
            ORDER BY message_id DESC
            LIMIT $initialRow, $finalRow";

    // Execute the query
    $result = mysqli_query($con, $sql);

    // Fetch all rows
    $messages = mysqli_fetch_all($result, MYSQLI_ASSOC);

    return $messages;
}


// function getLastMessagesInInbox($con, $receiverId)
// {
    // Prepare the select query to fetch the last undeleted message from each sender to the receiver
    // $sql = "SELECT messages.*, 
            // (SELECT COUNT(*) FROM messages AS m
             // WHERE m.receiver_id = messages.receiver_id
             // AND m.sender_id = messages.sender_id
             // AND m.seen_at IS NULL) AS unread_count
            // FROM messages
            // INNER JOIN (
                // SELECT MAX(message_id) AS last_message_id
                // FROM messages
                // WHERE receiver_id = '$receiverId' AND is_deleted = 0
                // GROUP BY sender_id
            // ) AS last_messages
            // ON messages.message_id = last_messages.last_message_id";

    // Execute the query
    // $result = mysqli_query($con, $sql);

    // Fetch all rows
    // $lastMessages = mysqli_fetch_all($result, MYSQLI_ASSOC);

    // return $lastMessages;
// }


 function getLastMessagesInInbox($con, $receiverId)
 {
       $sql = "SELECT messages.*, 
                   user.username, 
                   (SELECT COUNT(*) FROM messages AS m
                    WHERE m.receiver_id = messages.receiver_id
                    AND m.sender_id = messages.sender_id
                    AND m.seen_at IS NULL) AS unread_count
            FROM messages
            INNER JOIN (
                SELECT MAX(message_id) AS last_message_id
                FROM messages
                WHERE receiver_id = '$receiverId' AND is_deleted = 0
                GROUP BY sender_id
            ) AS last_messages ON messages.message_id = last_messages.last_message_id
            INNER JOIN user ON user.user_id = messages.sender_id";

   
    $result = mysqli_query($con, $sql);

   
    $lastMessages = mysqli_fetch_all($result, MYSQLI_ASSOC);

    return $lastMessages;
}








// Function to update is_deleted field for a message
function updateIsDeleted($con, $messageId)
{
    // Prepare the update query to set is_deleted to 1
    $sql = "UPDATE messages SET is_deleted = 1 WHERE message_id = '$messageId'";

    // Execute the query
    if (mysqli_query($con, $sql)) {
        return "is_deleted updated successfully for message with ID: $messageId.";
    } else {
        return "Error updating is_deleted: " . mysqli_error($con);
    }
}



// Check if the required parameters are set
if (isset($_POST['request_type'])) {
    $requestType = $_POST['request_type'];

    if ($requestType === 'send_message') {
        if (isset($_POST['sender_id'], $_POST['receiver_id'], $_POST['message_text'])) {
            echo sendMessage($con, $_POST['sender_id'], $_POST['receiver_id'], $_POST['message_text']);
        } else {
            echo "Invalid parameters for sending a message.";
        }
    } elseif ($requestType === 'receive_messages') {
        if (isset($_POST['receiver_id'])) {
            $receivedMessages = receiveMessages($con, $_POST['receiver_id']);
            echo json_encode($receivedMessages);
        } else {
            echo "Invalid parameters for receiving messages.";
        }
    } elseif ($requestType === 'update_seen_at') {
        if (isset($_POST['message_id'])) {
            echo updateSeenAt($con, $_POST['message_id']);
        } else {
            echo "Invalid parameters for updating seen_at.";
        }
    }
      elseif ($requestType === 'get_messages_between_users') {
        if (isset($_POST['sender_id'], $_POST['receiver_id'], $_POST['initial_row'], $_POST['final_row'])) {
            $senderId = $_POST['sender_id'];
            $receiverId = $_POST['receiver_id'];
            $initialRow = $_POST['initial_row'];
            $finalRow = $_POST['final_row'];
            $messages = getMessagesBetweenUsers($con, $senderId, $receiverId, $initialRow, $finalRow);
            echo json_encode($messages);
        } else {
            echo "Invalid parameters for getting messages between users.";
        }
    }
      elseif ($requestType === 'get_last_messages_in_inbox') {
        if (isset($_POST['receiver_id'])) {
            $receiverId = $_POST['receiver_id'];
            $lastMessages = getLastMessagesInInbox($con, $receiverId);
            echo json_encode($lastMessages);
        } else {
            echo "Invalid parameters for getting last messages in inbox.";
        }
    }
     elseif ($requestType === 'update_is_deleted') {
        // Check if message_id is set for deletion
        if (isset($_POST['message_id'])) {
            $messageId = $_POST['message_id'];
            $updateResult = updateIsDeleted($con, $messageId);
            echo $updateResult;
        } else {
            echo "Invalid parameters for updating is_deleted.";
        }
    }
 else {
        echo "Invalid request type.";
    }
} else {
    echo "Request type parameter is missing.";
}