<?php
require "connection.php";

$response = array();

// Assuming you have received these values from your mobile app
$location_name = isset($_POST["location_name"]) ? $_POST["location_name"] : null;

// Check if location_name is provided
if ($location_name !== null) {
    // Retrieve products based on the specified location
    $getProductsQuery = "SELECT * FROM sell_tbl WHERE location_name = '$location_name'";
    $getProductsResult = mysqli_query($con, $getProductsQuery);

    if ($getProductsResult) {
        // Check if any products were found
        $productCount = mysqli_num_rows($getProductsResult);

        if ($productCount > 0) {
            // Products found, fetch the results
            $products = array();

            while ($row = mysqli_fetch_assoc($getProductsResult)) {
                $products[] = $row;
            }

            $response["error"] = "200";
            $response["message"] = "Products retrieved successfully";
            $response["product_count"] = $productCount;
            $response["products"] = $products;
        } else {
            // No products found for the specified location
            $response["error"] = "404";
            $response["message"] = "No products found for the specified location";
        }
    } else {
        // Error executing query
        $response["error"] = "500";
        $response["message"] = "Error executing query: " . mysqli_error($con);
    }
} else {
    // Invalid request, location_name is not provided
    $response["error"] = "400";
    $response["message"] = "Invalid request, location_name is not provided";
}

echo json_encode($response);

mysqli_close($con);
?>
